<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <!-- Variable to hold unit string -->
    <xsl:variable name="unit">
        <xsl:choose>
            <xsl:when test="//@linearUnits = 'Imperial'"> st</xsl:when>
            <xsl:otherwise> m</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <!-- Horizontal Alignment Legal Description from Reference -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html lang="en">
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title>Popis Směrové řešení z reference</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!-- Report Title -->
                                <h2>Popis Směrové řešení z regerence</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!-- Project Data -->
                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Popis:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@file"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Poslední úprava:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Koeficient vstupního rastru:&#xa0; </th>
                                            <td align="left" style="font-size: 80%">
                                                <xsl:value-of select="../@inputGridScaleFactor"/>
                                            </td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách, </xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech, </xsl:if>
                                                pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>
                                <!-- Horizontal Alignment Data -->
                                <div style="margin-left:0.5in;margin-right:0.5in">
                                    <xsl:for-each select="HorizontalAlignment">
                                        <table cellpadding="2">
                                            <tbody>
                                                <tr>
                                                    <th align="right"><br/>Trasa Název:&#xa0; </th>
                                                    <td align="left"><br/><xsl:value-of select="@name"/></td>
                                                </tr>
                                                <tr>
                                                    <th align="right">Trasa Popis:&#xa0; </th>
                                                    <td align="left"><xsl:value-of select="@description"/></td>
                                                </tr>
                                                <tr>
                                                    <th align="right" valign="top">Referenční trasa:&#xa0; </th>
                                                    <td align="left" valign="top">
                                                        <xsl:value-of select="//legalReference/@referenceAlignment"/><br/>&#xa0;
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <xsl:apply-templates select="HorizontalElements/HorizontalLine | HorizontalElements/HorizontalCircle | HorizontalElements/HorizontalSpiral"/>
                                        <xsl:if test="@area > 0">
                                            a POČÁTEČNÍ BOD.<br/><br/>
                                            Popisovaná parcela má plochu 
                                            <xsl:if test="//@linearUnits = 'Imperial'">
                                                <xsl:value-of select="cif:acreFormat(number(@area) div 43560)"/> akrů
                                                (<xsl:value-of select="cif:areaFormat(number(@area))"/> st2)
                                            </xsl:if>
                                            <xsl:if test="//@linearUnits = 'Metric'">
                                                <xsl:value-of select="cif:acreFormat(number(@area) div 10000)"/> hektarů
                                                (<xsl:value-of select="cif:areaFormat(number(@area))"/> m2
                                            </xsl:if>
                                        </xsl:if>
                                        <br/>
                                    </xsl:for-each>
                                </div>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <!-- Horizontal Line -->
    <xsl:template match="HorizontalLine">
        <xsl:if test="position() = 1">
            Začíná v
            <xsl:choose>
                <xsl:when test="Start/@name"><xsl:value-of select="Start/@name"/>,<br/></xsl:when>
                <xsl:otherwise>bodě,<br/></xsl:otherwise>
            </xsl:choose>
             tento bod je POČÁTEČNÍ BOD;<br/>
        </xsl:if>
        odtud 
        <xsl:value-of select="cif:directionFormat(number(@direction))"/>,
        <xsl:value-of select="cif:distanceFormat(number(@length))"/>
        <xsl:value-of select="$unit"/>
        <xsl:choose>
            <xsl:when test="End/@name">
                k bodu <xsl:value-of select="End/@name"/><br/>
            </xsl:when>
            <xsl:otherwise><br/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- Horizontal Circle -->
    <xsl:template match="HorizontalCircle">
        <xsl:if test="position() = 1">
            Začíná v
            <xsl:choose>
                <xsl:when test="Start/@name">
                    <xsl:value-of select="Start/@name"/>,<br/>
                </xsl:when>
                <xsl:otherwise>
                    bodě,<br/>
                </xsl:otherwise>
            </xsl:choose>
             tento bod je POČÁTEČNÍ BOD;<br/>
        </xsl:if>
        odtud podél oblouku 
        <xsl:value-of select="cif:distanceFormat(number(@length))"/>
        <xsl:value-of select="$unit"/>
        <xsl:if test="Start/legalReference/@offset >= 0"> doprava</xsl:if>
        <xsl:if test="Start/legalReference/@offset &lt; 0"> doleva</xsl:if>
        <xsl:text>, </xsl:text><br/>
        o poloměru <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
        <xsl:value-of select="$unit"/>
        , s tětivou <br/>
        <xsl:value-of select="cif:directionFormat(number(@chordDirection))"/>,
        <xsl:value-of select="cif:distanceFormat(number(@chord))"/>
        <xsl:value-of select="$unit"/>
        <xsl:choose>
            <xsl:when test="End/@name">
                do bodu <xsl:value-of select="End/@name"/><br/>
            </xsl:when>
            <xsl:otherwise><br/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- Horizontal Spiral -->
    <xsl:template match="HorizontalSpiral">
        <xsl:if test="position() = 1">
            Začíná v
            <xsl:choose>
                <xsl:when test="Start/@name">
                    <xsl:value-of select="Start/@name"/>,<br/>
                </xsl:when>
                <xsl:otherwise>
                    bodě,<br/>
                </xsl:otherwise>
            </xsl:choose>
             tento bod je POČÁTEČNÍ BOD;<br/>
        </xsl:if>
        odtud podél přechodnice 
        <xsl:value-of select="cif:distanceFormat(number(@length))"/>
        <xsl:value-of select="$unit"/>
        <xsl:if test="Start/legalReference/@offset >= 0"> doprava</xsl:if>
        <xsl:if test="Start/legalReference/@offset &lt; 0"> doleva</xsl:if>
        <xsl:text>, s tětivou </xsl:text><br/>
        <xsl:value-of select="cif:directionFormat(number(@chordDirection))"/>,
        <xsl:value-of select="cif:distanceFormat(number(@longChord))"/>
        <xsl:value-of select="$unit"/>
        <xsl:choose>
            <xsl:when test="End/@name">
                do bodu <xsl:value-of select="End/@name"/><br/>
            </xsl:when>
            <xsl:otherwise><br/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Pro tento výpis musíte vybrat nejméně jedno směrové řešení v <em>Zahrnout</em> v
                <em>Nástroje &gt; XML Výpisy &gt; Uzavřené prvky</em> nebo <em>Nástroje &gt; XML 
                Výpisy &gt; Geometrie</em>.
            </p>
            <p class="normal1" lang="en">
                Tento popis vyžaduje referenční trasu zadanou v poli <em>Referenční trasy &gt; Zahrnout</em> v <em>Nástroje &gt; XML Výpisy &gt; Uzavřené prvky</em>, 
                aby byl kompletní.
            </p>
            <p class="normal1" lang="en">
                Pro kompletní výpis je potřeba, aby body směrového řešení byly pojmenované.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2006 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
